//
//  AccessCoreSdk.h
//  platform-core-sdk
//
//  Created by 冯超 on 2021/9/17.
//

#import <Foundation/Foundation.h>
#import <platform_core_sdk/AccessCoreCallbackUtils.h>

NS_ASSUME_NONNULL_BEGIN

typedef enum _EVENTTYPE {
    ACCESS_ENTER_SERVER = 1,    // 进服,首次安装
    ACCESS_LEVEL_UP,            // 升级
    ACCESS_CREATE_ROLE,         // 创角色
    ACCESS_CUSTOMER_ACTION      // 其他
}EventType;

typedef enum _THREE_SHARE_TYPE {
    ACCESS_SCENESESSION = 0,     // 微信好友
    ACCESS_SCENETIMELINE,        // 微信朋友圈
    ACCESS_SCENEQQTOSESSION,     // QQ好友
    ACCESS_SCENEQQTOQZONE,       // QQ空间
    ACCESS_DONGQIUDI,            // 懂球帝
    ACCESS_FACEBOOK_LINK,       // facebook分享链接(海外)
    ACCESS_FACEBOOK_IMAGE,      // facebook分享图片(海外)
    ACCESS_FACEBOOK_VIDEO,      // facebook分享视频(海外)
    ACCESS_APPLE_SHARE          // apple分享(海外)
} THREE_SHARE_TYPE;

typedef enum _ACTIVITY_TYPE {
    ACCESS_NO_ACTIVITY = 0,     // 没有活动
    ACCESS_CD_KEY,              // cdk 类型
}ACTIVITY_TYPE;

@class AccessBeginPayInfo;
@class AccessPlayerInfo;
@class AccessShareInfo;
@class AccessActivityDataInfo;

@interface AccessCoreSdk : NSObject

@property(nonatomic, weak) id<HLSystemDelegate> systemDelegate;
@property(nonatomic, weak) id<HLPaymentDelegate> paymentDelegate;
@property(nonatomic, weak) id<HLAccountDelegate> accountDelegate;
@property(nonatomic, weak) id<HLShareCallback> shareDelegate;

/*
 * 为了保证SDK能正常的运行，请在 AppDelegate->didFinishLaunchingWithOptions 方法中优先进行初始化操作。
 * 单利初始化
 */
+ (instancetype)shareAccessCoreSdkManage;

/**
 *  登陆
 */
- (void)login;

/**
 *  登出
 */
- (void)logout;

/**
 * 上报用户信息至SDK
 * @param type  上报的数据类型
 * @param info 用户信息，不能为空
 */
- (void)report:(EventType)type data:(AccessPlayerInfo *)info;
- (void)setUserExtDataType:(EventType)type data:(AccessPlayerInfo *)userExtData DEPRECATED_MSG_ATTRIBUTE("Please use -report:info:");

/**
 * 自定义数据报送
 * @param action 事件名称，不可为空或者null
 * @param gameinfo 报送的扩展信息
 */
- (void)gameDataReport:(NSString *)action withGameInfo:(NSMutableDictionary *)gameinfo DEPRECATED_MSG_ATTRIBUTE("Please use AccessPlayerInfo Class 来进行自定义报送。");

/**
 * 获取商品信息
 */
- (void)queryGoodsInfo;

/**
 * 获取CDK接口
 */
- (void)accessParticipate:(ACTIVITY_TYPE)activityType ActivityDataType:(AccessActivityDataInfo*)activityDataType;

/**
 *  开始支付
 */
- (void)pay:(AccessBeginPayInfo *)goodsModel;

/*
 * 提示: 分享只能单选一种分享模式，文案跟图片不能一起分享(懂球帝分享除外)。创建AccessShareInfo,给对应的属性赋值即可。
 * type  分享平台类型
 * object  分享平台的内容
 */
- (void)shareType:(THREE_SHARE_TYPE)type shareObject:(AccessShareInfo *)object;

/*
 *打开账号管理中心（海外）
 */
- (void)openAccountCenter;

/*
 *打开客服中心（海外）
 */
- (void)openService;

@end

NS_ASSUME_NONNULL_END
