//
//  AccessUserExtData.h
//  platform-core-sdk
//
//  Created by 冯超 on 2021/11/13.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface AccessPlayerInfo : NSObject

@property (nonatomic, strong) NSString *server_name; //服务名称
@property (nonatomic, strong) NSString *zone_id; // 区ID
@property (nonatomic, strong) NSString *zone_name;//区名称
@property (nonatomic, strong) NSString *server_id;//服务ID
@property (nonatomic, strong) NSString *role_id;//角色ID
@property (nonatomic, strong) NSString *role_name;//角色名称
@property (nonatomic, strong) NSString *role_level;//角色等级
@property (nonatomic, strong) NSString *party_name;//帮派名
@property (nonatomic, strong) NSString *vip; //vip
@property (nonatomic, strong) NSString *balance;//余额
@property (nonatomic, strong) NSString *phylum;//分类/步骤
@property (nonatomic, strong) NSString *classfield;//行为结果
@property (nonatomic, strong) NSString *extene_action;//点名称
@property (nonatomic, strong) NSString *extra;

/**
 * 自定义数据报送
 * @param key 事件名称，不可为空或者null
 * @param val 报送的信息 类型：int
 */
- (void)addExtra:(NSString*)key intValue:(int)val;

/**
 * 自定义数据报送
 * @param key 事件名称，不可为空或者null
 * @param val 报送的信息 类型：double
 */
- (void)addExtra:(NSString*)key doubleValue:(double)val;

/**
 * 自定义数据报送
 * @param key 事件名称，不可为空或者null
 * @param val 报送的信息 类型：NSString
 */
- (void)addExtra:(NSString*)key NSStringValue:(NSString *)val;

@end

NS_ASSUME_NONNULL_END
