//
//  CallbackUtils.h
//  AccessSDK
//
//  Created by 邓超小号的M2 on 2024/1/17.
//

#import <Foundation/Foundation.h>

#import "PayProduct.h"
#import "ACReturnValue.h"
#import "ServerInfos.h"
#import "ACUserLoginResponse.h"


#pragma mark - 初始化

@protocol InitCallback <NSObject>

@required

- (void)onInitSucceeded:(NSDictionary*)result;

- (void)onInitFailed:(NSString*)result;

@optional

@end


#pragma mark - 支付

@protocol PayCallback <NSObject>

@required

- (void)onPaySuccess:(NSString*)param;

- (void)onPayFail:(NSString*)param;

- (void)onPayCancle:(NSString*)description DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@optional

/**
 * 获取支付产品的回调
 */
- (void)onProductInfo:(NSArray<PayProduct *>*)products;

@end

#pragma mark - 分享

@protocol ShareCallback <NSObject>

@required

- (void)shareSucceeded:(BOOL)result;

- (void)shareFailed:(BOOL)result;

@optional

@end

#pragma mark - 报送

typedef enum _STORE_PROMOTION_SETTING {
    sUPDATE_PROMOTION_ORDER = 0,
    sUPDATE_PROMOTION_VISIBILITY_HIDE,
    sUPDATE_PROMOTION_VISIBILITY_SHOW,
} STORE_PROMOTION_SETTING;


@protocol ReportCallback <NSObject>

@optional

- (void)onSendBIResult:(NSString*)msg DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

- (BOOL)onMaintenance:(NSString*)msg DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@end



#pragma mark - 用户

@protocol UserCallback <NSObject>

@required

- (void)onLoginSucceeded:(ACUserLoginResponse*)userInfo;

- (void)onLoginFailed:(ACReturnValue*)returnValue;

- (void)onLogout:(NSString*)msg;

@optional

/**
 *  绑定手机回调
 *
 *  @param msg 信息
 */
- (void)onBindPhone:(NSString*)msg DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");


/**
 *  游戏退出回调
 *
 *  @param msg 描述
 */
- (void)onExit:(NSString*)msg DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  获取服务器列表成功回调
 *
 *  @param serverInfos 服务器列表信息
 */
- (void)onGetServerListSuccess:(ServerInfos*)serverInfos DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  获取服务器列表失败回调
 *
 *  @param msg 失败信息
 */
- (void)onGetServerListFail:(NSString*)msg DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  选服成功回调
 *
 *  @param serverId 选服id
 */
- (void)onSelectServerSuccess:(NSString*)serverId DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  选服失败回调
 *
 *  @param serverId 选服id
 */
- (void)onSelectServerFail:(NSString*)serverId DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");


@end

#pragma mark - 拓展回调

@protocol InvokeCallback <NSObject>

@optional

/**
 * 拓展回调
 */
- (void)onInvokeMethod:(NSString*)method data:(NSString*)data DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@end


#pragma mark - 推送回调

@protocol NoticeBackInfo <NSObject>

@optional
/**
 * 推送初始化成功
 *
 * @param deviceToken  生成的Device Token
 * @param hoolaiToken  生成的 Token 推送消息时需要使用此值。
 */
- (void)noticePushRegisteredSuccess:(NSString *)deviceToken hoolaiToken:(NSString *)hoolaiToken DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 * 推送初始化失败
 *
 * @param error 错误信息
 */
- (void)noticePushRegisteredFailure:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 * 通知授权回调
 *
 * @param isEnable 用户是否授权
 */
- (void)pushDidRequestNotificationPermission:(BOOL)isEnable error:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 * 统一接收消息的回调
 *
 * @param notification 消息对象
 * 区分消息类型说明：xg字段里的msgtype为1则代表通知消息,msgtype为2则代表静默消息,msgtype为9则代表本地通知
 */
- (void)pushDidReceiveRemoteNotification:(NSDictionary *)notification DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 * 统一点击回调
 *
 * 区分消息类型说明：xg字段里的msgtype为1则代表通知消息,msgtype为9则代表本地通知
 */
- (void)pushDidReceiveNotificationResponse:(NSDictionary *)response DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  对应appendTags:的回调
 *
 * @param tags 标签数组
 * @param error 绑定标签的结果信息
 */
- (void)pushDidAppendTags:(NSArray<NSString *> *)tags error:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  对应delTags:的回调
 *
 * @param tags 标签数组
 * @param error 解绑标签的结果信息
 */
- (void)pushDidDelTags:(NSArray<NSString *> *)tags error:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  对应clearAndAppendTags:的回调
 *
 *  @param tags 标签数组
 *  @param error 更新标签的结果信息
 */
- (void)pushDidClearAndAppendTags:(NSArray<NSString *> *)tags error:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  对应clearTags的回调
 *
 *  @param error 清除标签的结果信息
 */
- (void)pushDidClearTagsError:(NSError *)error DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  对应queryTags:的回调
 *
 *  @param tags 标签数组
 *  @param totalCount 绑定的所有标签总数
 *  @param error 查询标签的结果信息
 */
- (void)pushDidQueryTags:(nullable NSArray<NSString *> *)tags totalCount:(NSUInteger)totalCount error:(nullable NSError *)error;

@end
