//
//  AccessSDK.h
//  AccessSDK
//
//  Created by 邓超小号的M2 on 2024/1/16.
//

#import <Foundation/Foundation.h>
#import "ACUserLoginResponse.h"
#import "ACPushMessage.h"
#import "HLShareModel.h"
#import "CallbackUtils.h"
#import "AccessAppDelegate.h"
#import "ACProductInfo.h"

typedef enum _AC_LOGIN_STATE {
    kLOGIN_STATE_NOT_LOGIN = 0,
    kLOGIN_STATE_GUEST_LOGIN,
    kLOGIN_STATE_NORMAL_LOGIN
} AC_LOGIN_STATE;

typedef enum _AC_SHARE_TYPE {
    kSHARE_TYPE_LINK,//分享链接
    kSHARE_TYPE_IMAGE,//分享图片
    kSHARE_TYPE_VIDEO//分享视频
} AC_SHARE_TYPE;

@protocol AccessProcessDelegate <NSObject>

@optional

- (void)onProcess:(NSInteger)code key:(NSString*)key message:(NSString*)message DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@end


@interface AccessSDK : NSObject

@property(nonatomic, weak) id<InitCallback> initDelegate;

@property(nonatomic, weak) id<UserCallback> userDelegate;

@property(nonatomic, weak) id<PayCallback> payDelegate;

@property(nonatomic, weak) id<ReportCallback> reportDelegate DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@property(nonatomic, weak) id<InvokeCallback> invokeDelegate DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@property(nonatomic, weak) id<NoticeBackInfo> notificationDelegate DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@property(nonatomic, weak) id<HLShareCallback> shareDelegate;

@property(nonatomic, readonly)AC_LOGIN_STATE currentLoginState DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@property(nonatomic, readonly)ACUserLoginResponse* userInfo;

+ (AccessSDK *)sharedInstance;

/**
 *  初始化接口，必须在设置完delegate后调用
 *  自动登陆
 */
- (void)initSDK;

/**
 *  初始化接口，必须在设置完delegate后调用
 *  自动登陆：YES  在sdk有账户的前提下调用登陆不弹登陆界面直接后台登陆并回调，没有账户直接弹出登陆框
 *  非自动登陆：NO 在有没有保存的账户是都弹出登陆界面
 *
 *  @param withSDKAutoLogin 是否自动登陆
 */
- (void)initSDK:(BOOL)withSDKAutoLogin DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  版本更新
 *
 *  @param version 客户端版本号，不能为空
 */
- (void)checkUpdate:(NSString*)version DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  登陆
 */
- (void)login;

/**
 *  登出
 */
- (void)logout DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  账号管理
 */
- (void)accountManager;


//海外版获取产品信息
- (void)getProductInfo:(NSArray<NSString *>*)itemIds;

//海外版支付
- (void)payWithProduct:(ACProductInfo *)payObj;

//中文版海外版都能用
/**
 *  支付
 *
 *  @param itemName     商品名，不能为空
 *  @param amount       支付金额（单位：分）
 *  @param callbackInfo 透传参数，不能为空
 */
- (void)payName:(NSString*)itemName amount:(int)amount callbackInfo:(NSString*)callbackInfo DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  切换账号
 */
- (void)switchAccount DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  退出游戏，不带确认框
 *
 *  @param msg 提示消息
 */
- (void)exitGame:(NSString*)msg DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  退出游戏，带确认框
 *
 *  @param msg 提示消息
 */
- (void)exitGameDialog:(NSString *)msg DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  获取服务器列表
 *
 *  @param version 服务器版本
 */
- (void)getServerList:(NSString*)version DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  选服
 *
 *  @param selectServerId 服务器id，不能为空
 */
- (void)selectServer:(NSString*)selectServerId DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  上报用户信息至SDK
 *
 *  @param userExtData 用户信息，不能为空
 */
- (void)setUserExtData:(NSMutableDictionary*)userExtData;

/**
 *  BI数据报送
 *
 *  @param metric   报送指标类型，不能为空
 *  @param jsonData 报送指标json串，不能为空
 */
- (void)sendBIData:(NSString *)metric jsonData:(NSString *)jsonData DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  打开社区
 */
- (void)enterBBS DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *  推送
 *
 *  @param message 推送配置
 */
- (void)pushMsg:(ACPushMessage*)message DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/*
 * 获取渠道
 */
- (NSString*)channel DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

- (BOOL)settingLanguage:(NSString*)language DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

- (NSDictionary<NSString*, NSString*>*)supportLanguages DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/*
 * 获取BI渠道
 */
- (NSString*)biChannel DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/*
 * 通用接口调用
 */
- (void)expandInvoke:(NSInteger)code params:(NSArray<NSString*>*)params processCallback:(id<AccessProcessDelegate>)callback DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/*
 * 通用接口调用扩展
 */
- (id)expandInvokePlus:(NSString *)methodName params:(NSArray<id>*)params DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/*
 * 分享
 */
- (void)shareWithSourceType:(AC_SHARE_TYPE)type andSourcePath:(NSString *)path andContentDescription:(NSString *)contentDescription success:(void (^)(NSString* platform, NSDictionary *result))success failure:(void (^)(NSString* platform, NSError *error))failure DEPRECATED_MSG_ATTRIBUTE("该方法已弃用: 请使用shareType:shareObject:");

/*
 * 提示: 分享只能单选一种分享模式，文案跟图片不能一起分享。创建HLShareModel,给对应的属性赋值即可。
 * type  分享平台类型
 * object  分享平台的内容
 */
- (void)shareType:(AC_SHARE_TYPE)type shareObject:(HLShareModel *)object;

/*
 * 打开客服
 */
- (BOOL)openService;

/**
 *   添加标签
 *
 *   @param tags 标签数组
 *   @note 此接口应该在pushDidRegisteredDeviceToken:hoolaiToken:error:返回正确之后被调用
 *   @note tags为标签字符串数组，最多不超过500个(标签字符串不允许有空格或者是tab字符，长度不超过50)
 */
- (BOOL)appendTags:(NSArray<NSString *> *)tags DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *   删除标签
 *
 *   @param tags 指定解绑标识，标签字符串不允许有空格或者是tab字符
 *   @note 此接口应该在pushDidRegisteredDeviceToken:hoolaiToken:error:返回正确之后被调用；若需要清除所有标识，建议使用 clearAllIdentifiers:；
 *   @note tags为标签字符串数组，最多不超过500个(标签字符串不允许有空格或者是tab字符，长度不超过50)
 */
- (BOOL)delTags:(NSArray<NSString *> *)tags DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *   清空已有标签
 *
 *   @note 此接口应该在pushDidRegisteredDeviceToken:hoolaiToken:error:返回正确之后被调用
 */
- (BOOL)clearTags DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *   清空已有标签，然后批量添加标签
 *
 *   @param tags 标签标识字符串数组，标签字符串不允许有空格或者是tab字符
 *   @note 此接口应该在pushDidRegisteredDeviceToken:hoolaiToken:error:返回正确之后被调用
 *   @note tags为标签字符串数组，最多不超过500个(标签字符串不允许有空格或者是tab字符，长度不超过50)
 */
- (BOOL)clearAndAppendTags:(NSArray<NSString *> *)tags DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

/**
 *   查询当前设备(hoolai token为准)绑定的标签
 *
 *   @param offset 此次查询的偏移大小
 *   @param lim 此次查询的分页大小, 最大200
 *   @note 举例:"limit 3 offset 1" 表示跳过1条数据,从第2条数据开始取，取3条数据，也就是取2,3,4三条数据
 *   举例: offset为0，则返回最新的标签集合
 */
- (BOOL)queryTags:(NSUInteger)offset limit:(NSUInteger)lim DEPRECATED_MSG_ATTRIBUTE("该方法已弃用~");

@end
