//
//  AccessCoreCallbackUtils.h
//  platform-core-sdk
//
//  Created by 冯超 on 2021/11/12.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class AccessLoginInfo;
@class AccessGoodsInfo;
@class AccessInitResult;

@protocol HLSystemDelegate <NSObject>

/**
 *  初始化成功
 *  @param initResult 初始化成功信息
 */
- (void)initSuccess:(AccessInitResult *)initResult;

/**
 *  初始化失败
 */
- (void)initFailed;

@end

@protocol HLPaymentDelegate <NSObject>

/**
 * 支付成功
 */
- (void)paySuccess;

/**
 * 支付失败
 * @param error 错误信息
 */
- (void)payError:(NSError *)error;

@optional
/**
 *  获取商品信息成功
 * @param info 商品信息
 */
- (void)payGoodsList:(NSArray <AccessGoodsInfo *>*)info;

/**
 *  获取商品失败
 */
- (void)payGpodsListFail;

@end

@protocol HLAccountDelegate <NSObject>

/**
 *  登录成功
 *  @param accountInfo 登录成功信息
 */
- (void)loginSuccess:(AccessLoginInfo *)accountInfo;

/**
 *  切换小号成功
 *  @param refreshAccountInfo 登录成功信息
 */
- (void)refreshUser:(AccessLoginInfo *)refreshAccountInfo;

/**
 *  登录失败
 */
- (void)loginFailure;

/**
 *  登出
 */
- (void)logout;

@end

@protocol HLShareCallback <NSObject>

/**
 * 分享成功
 */
- (void)shareSucceeded:(BOOL)result;

/**
 *  分享失败
 */
- (void)shareFailed:(BOOL)result;

@end

NS_ASSUME_NONNULL_END
