//
//  ACUserLoginResponse.h
//  AccessSDK
//
//  Created by 邓超小号的M2 on 2024/1/17.
//

#import <Foundation/Foundation.h>
#import "ACServerInfo.h"
#import "ACTripartiteBindInfo.h"

NS_ASSUME_NONNULL_BEGIN

@interface ACUserLoginResponse : NSObject<NSCoding> {
    long long uid;
    int bindChannelTag;
    NSString* accessToken;
    ACServerInfo* lastServerInfo;
    NSString* nickName;
    NSString *channelToken;
    NSDictionary* extendInfo;
    NSArray<ACTripartiteBindInfo *>* tripartiteBindInfo;
    NSString* channelUid;
    NSString* channel;
    NSDate* expirationDate;
    NSInteger productId;
    
    NSString* realName;
    NSString* identityCard;
    
    NSString* serverArea;
    
    NSDictionary *appData;
    NSString *channelCode;
}

@property (nonatomic, assign) long long uid;
@property (nonatomic, assign) int bindChannelTag;
@property (nonatomic, strong) NSString* accessToken;
@property (nonatomic, strong) ACServerInfo* lastServerInfo;
@property (nonatomic, strong) NSString* nickName;
@property (nonatomic, strong) NSArray* tripartiteBindInfo;
@property (nonatomic, strong) NSString *channelToken;
@property (nonatomic, strong) NSDictionary* extendInfo;
@property (nonatomic, strong) NSString* channelUid;
@property (nonatomic, strong) NSString* channel;
@property (nonatomic, retain) NSDate* expirationDate;
@property (nonatomic, assign) NSInteger productId;
@property (nonatomic, strong) NSString* realName;
@property (nonatomic, strong) NSString* identityCard;
@property (nonatomic, strong) NSString* serverArea;

@property (nonatomic, strong) NSDictionary *appData;
@property (nonatomic, strong) NSString *channelCode;

@end

NS_ASSUME_NONNULL_END
