﻿using System;
using System.Collections.Generic;

public class HoolaiListener : IPlatformCallbackListener
{
    private static HoolaiListener _instance;
    private List<GoodsInfo> _cachedGoodsList;

    //商品列表更新事件
    public event Action<List<GoodsInfo>> OnGoodsListUpdated;

    public ExitConfirmationDialog exitDialog;

    public static HoolaiListener Instance
    {
        get
        {
            if (_instance == null)
            {
                _instance = new HoolaiListener();
            }
            return _instance;
        }
    }

    private HoolaiListener()
    {
        // 自动设置监听器
        PlatformCallback.SetListener(this);
    }

    // 初始化退出标准警告
    public void SetExitConfirmationDialog(ExitConfirmationDialog dialog)
    {
        exitDialog = dialog;  // 保存对话框实例
    }

    public void OnInitSuccess(InitResult result)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnInitSuccess GameId:{result.gameId} channel:{result.channel} channelId:{result.channelId}");
    }

    public void OnInitFailed(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnInitFailed reason:{reason}");
    }

    public void OnLoginFailed(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnLoginFailed reason:{reason}");

    }

    public void OnLoginSuccess(LoginResult result)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnLoginSuccess uid:{result.uid} channel:{result.channel} channelId:{result.accessToken}");
    }

    public void OnRefreshUser(LoginResult result)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnRefreshUser uid:{result.uid} channel:{result.channel} channelId:{result.accessToken}");
    }

    public void OnLogout(string message)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnLogout reason:{message}");
    }

    public void OnPayFailed(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnPayFailed reason:{reason}");
    }

    public void OnPayGoodsList(List<GoodsInfo> goodsList)
    {
        _cachedGoodsList = goodsList;
        OnGoodsListUpdated?.Invoke(goodsList);
        NativeLogger.I("Game_Unity_Callback", $"OnPayGoodsList count:{goodsList?.Count ?? 0}");
    }

    // 获取缓存的商品列表
    public List<GoodsInfo> GetCachedGoodsList()
    {
        return _cachedGoodsList;
    }

    public void OnPaySuccess(string message)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnPaySuccess message:{message}");
    }

    public void OnShareFailed(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnShareFailed reason:{reason}");
    }

    public void OnShareSuccess(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnShareSuccess reason:{reason}");
    }

    public void OnUpdate(string data)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnUpdate data:{data}");
    }

    public void OnCustomExit()
    {
        NativeLogger.I("Game_Unity_Callback", $"OnCustomExit show Game Exit Dialog!");
        if (exitDialog != null)
        {
            exitDialog.ShowDialog(); // 显示确认对话框
        }
        else
        {
            NativeLogger.I("Game_Unity_Callback", "ExitConfirmationDialog is not set!");
        }
    }
}
