﻿using System;
using System.Collections.Generic;

public class HoolaiListener : IPlatformCallbackListener
{
    private static HoolaiListener _instance;
    private List<GoodsInfo> _cachedGoodsList;

    //商品列表更新事件
    public event Action<List<GoodsInfo>> OnGoodsListUpdated;

    public static HoolaiListener Instance
    {
        get
        {
            if (_instance == null)
            {
                _instance = new HoolaiListener();
            }
            return _instance;
        }
    }

    private HoolaiListener()
    {
        // 自动设置监听器
        PlatformCallback.SetListener(this);
    }

    public void OnInitSuccess(InitResult result)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnInitSuccess GameId:{result.gameId} channel:{result.channel} channelId:{result.channelId}");
    }

    public void OnInitFailed(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnInitFailed reason:{reason}");
    }

    public void OnLoginFailed(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnLoginFailed reason:{reason}");

    }

    public void OnLoginSuccess(LoginResult result)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnLoginSuccess uid:{result.uid} channel:{result.channel} channelId:{result.accessToken}");
    }

    public void OnRefreshUser(LoginResult result)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnRefreshUser uid:{result.uid} channel:{result.channel} channelId:{result.accessToken}");
    }

    public void OnLogout(string message)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnLogout reason:{message}");
    }

    public void OnPayFailed(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnPayFailed reason:{reason}");
    }

    public void OnPayGoodsList(List<GoodsInfo> goodsList)
    {
        _cachedGoodsList = goodsList;
        OnGoodsListUpdated?.Invoke(goodsList);
        NativeLogger.I("fastsdk_unity_result", $"OnPayGoodsList count:{goodsList?.Count ?? 0}");
    }

    // 获取缓存的商品列表
    public List<GoodsInfo> GetCachedGoodsList()
    {
        return _cachedGoodsList;
    }

    public void OnPaySuccess(string message)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnPaySuccess message:{message}");
    }

    public void OnShareFailed(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnShareFailed reason:{reason}");
    }

    public void OnShareSuccess(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnShareSuccess reason:{reason}");
    }

    public void OnUpdate(string data)
    {
        NativeLogger.I("fastsdk_unity_result", $"OnUpdate data:{data}");
    }

    public void OnCustomExit()
    {
        NativeLogger.I("fastsdk_unity_result", $"OnCustomExit");
    }
}
