using System;
using Newtonsoft.Json;
using UnityEngine;

public static class HoolaiSdkManager
{
    // ==================== 登录 ====================
    public static void Login()
    {
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkLogin();
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.LoginSdk();
#else
        Debug.Log("【UnifiedSdkManager】模拟调用：登录");
#endif
    }

    // ==================== 登出 ====================
    public static void Logout()
    {
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkLogout();
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.LogoutSdk();
#else
        Debug.Log("【UnifiedSdkManager】模拟调用：登出");
#endif
    }

    // ==================== 支付 ====================
    public static void StartPay(PayParams payParams)
    {
        string jsonStr = JsonConvert.SerializeObject(payParams);
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkStartPay(jsonStr);
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.StartPay(jsonStr);
#else
        Debug.Log($"【UnifiedSdkManager】模拟调用：支付，参数={jsonStr}");
#endif
    }

    // ==================== 数据上报 ====================
    public static void SendEvent(EventType eventType, PlayerInfo playerInfo)
    {
        string jsonStr = JsonConvert.SerializeObject(playerInfo);
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkSendEvent(eventType, jsonStr);
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.ReportUserInfoFull(eventType, jsonStr);
#else
        Debug.Log($"【UnifiedSdkManager】模拟调用：数据上报，类型={eventType}，参数={jsonStr}");
#endif
    }

    // ==================== 查询商品信息 ====================
    public static void QueryGoodsInfo()
    {
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkQueryGoodsInfo();
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.QueryGoodsInfo();
#else
        Debug.Log("【UnifiedSdkManager】模拟调用：查询商品信息");
#endif
    }

    // ==================== CDKey 活动 ====================
    public static void AccessParticipate(AccessActivityType accessType, string cdKey)
    {
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkCDKey(accessType,cdKey);
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.AccessParticipate(accessType, cdKey);
#else
        Debug.Log($"【UnifiedSdkManager】模拟调用：参与活动，CDKey={cdKey}");
#endif
    }

    // ==================== 打开客服 ====================
    public static void OpenService()
    {
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkOpenService();
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.OpenService();
#else
        Debug.Log("【UnifiedSdkManager】模拟调用：打开客服");
#endif
    }

    // ==================== 打开账号中心 ====================
    public static void OpenAccountCenter()
    {
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkOpenAccount();
#elif UNITY_IOS && !UNITY_EDITOR
        IosSdkInterface.OpenAccountCenter();
#else
        Debug.Log("【UnifiedSdkManager】模拟调用：打开账号中心");
#endif
    }

    // ==================== 分享 ====================
    public static void ShareData(ShareType shareType, string jsonStr)
    {
        int type = (int)shareType;
#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkShareData(type, jsonStr);
#elif UNITY_IOS && !UNITY_EDITOR
        // iOS 分享参数解析（可根据需要扩展）
        Debug.Log("【UnifiedSdkManager】iOS 分享暂未实现完整解析");
        IosSdkInterface.StartShare(shareType, "Title", "Content", "https://example.com");
#else
        Debug.Log($"【UnifiedSdkManager】模拟调用：分享，平台={shareType}");
#endif
    }

    // ==================== 退出游戏 ====================
    public static void ExitGame()
    {

#if UNITY_ANDROID && !UNITY_EDITOR
        AndroidSdkInterface.CallSdkExit();
#elif UNITY_IOS && !UNITY_EDITOR
        // iOS 通常不直接退出应用
        Debug.Log("【UnifiedSdkManager】iOS 不支持直接退出应用");
#else
        Debug.Log("【UnifiedSdkManager】模拟调用：退出游戏");
#endif
    }

    public static void ShareData(object qQ, ShareType qQ_SESSION, string jsonStr)
    {
        throw new NotImplementedException();
    }
}
