using Newtonsoft.Json;
using UnityEngine.Scripting;

[Preserve]
public class PlayerInfo
{
    [JsonProperty("roleId")]
    public string RoleId;

    [JsonProperty("roleName")]
    public string RoleName;

    [JsonProperty("roleLevel")]
    public string RoleLevel;

    [JsonProperty("zoneId")]
    public string ZoneId;

    [JsonProperty("zoneName")]
    public string ZoneName;

    [JsonProperty("serverId")]
    public string ServerId;

    [JsonProperty("serverName")]
    public string ServerName;

    [JsonProperty("balance")]
    public string Balance;

    [JsonProperty("vip")]
    public string Vip;

    [JsonProperty("partyName")]
    public string PartyName;

    [JsonProperty("appVersion")]
    public string AppVersion;

    [JsonProperty("appResVersion")]
    public string AppResVersion;

    [JsonProperty("extendAction")]
    public string ExtendAction;

    [JsonProperty("roleCreateTime")]
    public string RoleCreateTime;

    [JsonProperty("phylum")]
    public string Phylum;

    [JsonProperty("classField")]
    public string ClassField;

    [Preserve]
    [JsonProperty("extra")]
    private string _extra;

    /// <summary>
    /// 获取 Extra 字段的值（只读）
    /// </summary>
    [JsonIgnore] 
    public string Extra => _extra;


    public void AddExtra(string key, int value)
    {
        if (string.IsNullOrEmpty(key)) return;
        _extra += key + ":" + CrateValue(value) + ",";
    }

    public void AddExtra(string key, double value)
    {
        if (string.IsNullOrEmpty(key)) return;
        _extra += key + ":" + CrateValue(value) + ",";
    }


    public void AddExtra(string key, string value)
    {
        if (string.IsNullOrEmpty(key) || value == null) return;
        _extra += key + ":" + CrateValue(value) + ",";
    }

    private string CrateValue(int val)
    {
        return "INT|||" + val;
    }

    private string CrateValue(double val)
    {
        return "DOUBLE|||" + val;
    }

    private string CrateValue(string val)
    {
        return val;
    }
}
