using System.Collections.Generic;
using Newtonsoft.Json;
using UnityEngine.Scripting;

[Preserve]
public class PayParams
{
    [JsonProperty("amount")]
    public int Amount;

    [JsonProperty("itemId")]
    public string ItemId;

    [JsonProperty("itemName")]
    public string ItemName;

    [JsonProperty("count")]
    public int Count;

    [JsonProperty("callbackInfo")]
    public string CallbackInfo;

    [JsonProperty("notifyUrl")]
    public string NotifyUrl;

    [JsonProperty("currency")]
    public string Currency;

    [JsonProperty("opt")]
    public Dictionary<string, string> Opt;

    public PayParams()
    {
        Opt = new Dictionary<string, string>();
    }

    public void AddOptionalParameter(string key, string value)
    {
        Opt[key] = value;
    }
}