﻿using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Scripting;

[Preserve]
public class HoolaiListener : IPlatformCallbackListener
{
    private static HoolaiListener _instance;
    private List<GoodsInfo> _cachedGoodsList;

    //商品列表更新事件
    public event Action<List<GoodsInfo>> OnGoodsListUpdated;

    public ExitConfirmationDialog exitDialog;

    public static HoolaiListener Instance
    {
        get
        {
            if (_instance == null)
            {
                _instance = new HoolaiListener();
            }
            return _instance;
        }
    }

    private HoolaiListener()
    {
        PlatformCallback.SetListener(this);;
    }

    // 初始化退出标准警告
    [Preserve]
    public void SetExitConfirmationDialog(ExitConfirmationDialog dialog)
    {
        exitDialog = dialog;  // 保存对话框实例
    }

    [Preserve]
    public void OnInitSuccess(InitResult result)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnInitSuccess GameId:{result.gameId} channel:{result.channel} channelId:{result.channelId}");
    }

    [Preserve]
    public void OnInitFailed(string reason)
    {;
        NativeLogger.I("Game_Unity_Callback", $"OnInitFailed reason:{reason}");
    }

    [Preserve]
    public void OnLoginFailed(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnLoginFailed reason:{reason}");

    }

    [Preserve]
    public void OnLoginSuccess(LoginResult result)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnLoginSuccess uid:{result.uid} channel:{result.channel} channelId:{result.accessToken}");
    }

    [Preserve]
    public void OnRefreshUser(LoginResult result)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnRefreshUser uid:{result.uid} channel:{result.channel} channelId:{result.accessToken}");
    }

    [Preserve]
    public void OnLogout(string message)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnLogout reason:{message}");
    }

    [Preserve]
    public void OnPayFailed(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnPayFailed reason:{reason}");
    }

    [Preserve]
    public void OnPayGoodsList(List<GoodsInfo> goodsList)
    {
        _cachedGoodsList = goodsList;
        OnGoodsListUpdated?.Invoke(goodsList);
        NativeLogger.I("Game_Unity_Callback", $"OnPayGoodsList count:{goodsList?.Count ?? 0}");
    }

    [Preserve]
    public List<GoodsInfo> GetCachedGoodsList()
    {
        return _cachedGoodsList;
    }

    [Preserve]
    public void OnPaySuccess(string message)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnPaySuccess message:{message}");
    }

    [Preserve]
    public void OnShareFailed(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnShareFailed reason:{reason}");
    }

    [Preserve]
    public void OnShareSuccess(string reason)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnShareSuccess reason:{reason}");
    }

    [Preserve]
    public void OnUpdate(string data)
    {
        NativeLogger.I("Game_Unity_Callback", $"OnUpdate data:{data}");
    }

    [Preserve]
    public void OnCustomExit()
    {
        NativeLogger.I("Game_Unity_Callback", $"OnCustomExit show Game Exit Dialog!");
        if (exitDialog != null)
        {
            exitDialog.ShowDialog(); // 显示确认对话框
        }
        else
        {
            NativeLogger.I("Game_Unity_Callback", "ExitConfirmationDialog is not set!");
        }
    }
}
