#if UNITY_IOS
using UnityEngine;
using System.Runtime.InteropServices;
using System;

public class IosSdkInterface
{
    // ================== DllImport 声明 ==================
    // 基础功能
    [DllImport("__Internal")] private static extern void _LoginSdk();
    [DllImport("__Internal")] private static extern void _LogoutSdk();

    // 支付功能
    [DllImport("__Internal")] private static extern void _QueryGoodsInfo();
    [DllImport("__Internal")] private static extern void _StartPay(string jsonInfo);

    // 分享功能
    [DllImport("__Internal")] private static extern void _StartShare(int shareType, string title, string content, string url);

    // 数据上报
    [DllImport("__Internal")] private static extern void _ReportUserInfoFull(int eventType, string jsonInfo);

    // 活动功能
    [DllImport("__Internal")] private static extern void _AccessParticipate(int activityType, string activityData);

    // 其他功能
    [DllImport("__Internal")] private static extern void _OpenAccountCenter();
    [DllImport("__Internal")] private static extern void _OpenService();



    // ========= C# 封装调用 ============
    public static void LoginSdk()
    {
        _LoginSdk();
    }

    public static void LogoutSdk()
    {
        _LogoutSdk();
    }

    public static void QueryGoodsInfo()
    {
        _QueryGoodsInfo();
    }

    public static void StartPay(string json)
    {
        _StartPay(json);
    }

    public static void StartShare(int shareType, string title, string imagePath, string url)
    {
        _StartShare(shareType, title, imagePath, url);
    }

    public static void ReportUserInfoFull(EventType eventType, string jsonStr)
    {
        int eventTypeCode = (int)eventType;
        _ReportUserInfoFull(eventTypeCode, jsonStr);
    }


    public static void AccessParticipate(AccessActivityType accessType, string cdKey = "")
    {
        int activityType = (int)accessType;
        _AccessParticipate(activityType, cdKey);
    }

    public static void OpenAccountCenter()
    {
        _OpenAccountCenter();
    }

    public static void OpenService()
    {
        _OpenService();
    }
}
#endif