using System.Collections.Generic;
using Newtonsoft.Json;


public class PayParams
{
    [JsonProperty("amount")]
    public int Amount { get; set; }

    [JsonProperty("itemId")]
    public string ItemId { get; set; }

    [JsonProperty("itemName")]
    public string ItemName { get; set; }

    [JsonProperty("count")]
    public int Count { get; set; }

    [JsonProperty("callbackInfo")]
    public string CallbackInfo { get; set; }

    [JsonProperty("notifyUrl")]
    public string NotifyUrl { get; set; }

    [JsonProperty("currency")]
    public string Currency { get; set; }

    [JsonProperty("opt")]
    public Dictionary<string, string> Opt { get; private set; }

    public PayParams()
    {
        Opt = new Dictionary<string, string>();
    }

    public void AddOptionalParameter(string key, string value)
    {
        Opt[key] = value;
    }
}