using Newtonsoft.Json;

public class PlayerInfo
{
    [JsonProperty("roleId")]
    public string RoleId { get; set; }

    [JsonProperty("roleName")]
    public string RoleName { get; set; }

    [JsonProperty("roleLevel")]
    public string RoleLevel { get; set; }

    [JsonProperty("zoneId")]
    public string ZoneId { get; set; }

    [JsonProperty("zoneName")]
    public string ZoneName { get; set; }

    [JsonProperty("serverId")]
    public string ServerId { get; set; }

    [JsonProperty("serverName")]
    public string ServerName { get; set; }

    [JsonProperty("balance")]
    public string Balance { get; set; }

    [JsonProperty("vip")]
    public string Vip { get; set; }

    [JsonProperty("partyName")]
    public string PartyName { get; set; }

    [JsonProperty("appVersion")]
    public string AppVersion { get; set; }

    [JsonProperty("appResVersion")]
    public string AppResVersion { get; set; }

    [JsonProperty("extendAction")]
    public string ExtendAction { get; set; }

    [JsonProperty("roleCreateTime")]
    public string RoleCreateTime { get; set; }

    [JsonProperty("phylum")]
    public string Phylum { get; set; }

    [JsonProperty("classField")]
    public string ClassField { get; set; }


    [JsonProperty("extra")]
    public string Extra { get; private set; }


    public void AddExtra(string key, int value)
    {
        if (string.IsNullOrEmpty(key)) return;
        Extra += key+":"+CrateValue(value)+",";
    }

    public void AddExtra(string key, double value)
    {
        if (string.IsNullOrEmpty(key)) return;
        Extra += key + ":" + CrateValue(value) + ",";
    }

    
    public void AddExtra(string key, string value)
    {
        if (string.IsNullOrEmpty(key) || value == null) return;
        Extra += key + ":" + CrateValue(value) + ",";
    }

    private string CrateValue(int val)
    {
        return "INT|||" + val;
    }

    private string CrateValue(double val)
    {
        return "DOUBLE|||" + val;
    }

    private string CrateValue(string val)
    {
        return val;
    }
}
