using System.Collections;
using System.Collections.Generic;
using Newtonsoft.Json;
using UnityEngine;

public class GameManager : MonoBehaviour
{
    public void OnLoginBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity","clicked login");
        //SdkPluginManager.CallSdkLogin();
        HoolaiSdkManager.Login();
    }

    public void OnLogoutBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked logout");
        HoolaiSdkManager.Logout();
    }


    public void OnEnterServerBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked EnterServer");
        PlayerInfo playerInfo = new PlayerInfo();
        playerInfo.RoleId = "1234567";
        playerInfo.RoleName = "大鹏一日同风起";
        playerInfo.RoleLevel = "999";
        playerInfo.ZoneId = "1";
        playerInfo.ZoneName = "傲视九重天";
        playerInfo.ServerId = "1";
        playerInfo.ServerName = "牛逼格拉斯";
        playerInfo.Balance = "9999";
        playerInfo.Vip = "99";
        playerInfo.PartyName = "少林寺";
        playerInfo.AppVersion = "1.0.1";
        playerInfo.AppResVersion = "100";
        playerInfo.ExtendAction = "无敌";
        playerInfo.RoleCreateTime = "";
        playerInfo.Phylum = "100";
        playerInfo.ClassField = "滴滴滴答";

        playerInfo.AddExtra("关卡 1", 1);
        playerInfo.AddExtra("血槽", 1000000.0);
        playerInfo.AddExtra("技能释放", "冰火九重天");


        HoolaiSdkManager.SendEvent(EventType.EnterServer, playerInfo);
        HoolaiSdkManager.SendEvent(EventType.CreateRole, playerInfo);
        HoolaiSdkManager.SendEvent(EventType.LevelUp, playerInfo);
        HoolaiSdkManager.SendEvent(EventType.CustomerAction, playerInfo);
    }


    public void OnPayBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked Pay");

        // 1. 创建并填充对象
        PayParams payParams = new PayParams
        {
            Amount = 100,
            ItemId = "sword_101",
            ItemName = "钻石",
            CallbackInfo = "123456_8888_987654321",
            NotifyUrl = "",
            Count = 1,
            Currency = "USD"
        };
        payParams.AddOptionalParameter("test", "daily_bonus");
        payParams.AddOptionalParameter("player_id", "p-98765");

        NativeLogger.I("fastsdk_btn_unity", $"clicked Exit jsonString: {payParams}");
        HoolaiSdkManager.StartPay(payParams);
    }

    public void OnExitBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked Exit");
        HoolaiSdkManager.ExitGame();
    }

    public void OnGetProductInfoBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked QueryGoodsInfo");
        HoolaiSdkManager.QueryGoodsInfo();
    }

    public void OnCDKBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked CDKey");
        HoolaiSdkManager.AccessParticipate(AccessActivityType.CD_KEY, "123456789");
    }


    public void OnShareBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked shareData");
        HoolaiSdkManager.ShareData(1, 1, "test");
    }

    public void OnOpenServiceBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked openService");
        HoolaiSdkManager.OpenService();
    }

    public void OnOpenAccountBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked openAccount");
        HoolaiSdkManager.OpenAccountCenter();
    }
}
