using System.Collections.Generic;
using Newtonsoft.Json;
using UnityEngine;


[System.Serializable]
public class InitResult
{
    public string channel;
    public int gameId;
    public int channelId;
}



[System.Serializable]
public class LoginResult
{
    public long uid;
    public string accessToken;
    public string channel;
    public string channelUid;   // 已弃用,默认为0 
    public string serverArea;
    public string extendInfo;   // 扩展参数转 JSON 字符串再传过来
}

[System.Serializable]
public class GoodsInfo
{
    public string currency;
    public string itemId;
    public string itemName;
    public string itemCount;
    public string itemPrice;
    public string showTag;
    public string region;//仅 iOS返回
    public string symbol;//仅 iOS返回
}

[System.Serializable]
public class GoodsListWrapper
{
    public List<GoodsInfo> array;
}

public class PlatformCallback : MonoBehaviour
{
    // 单例实现，确保只有一个接收器实例
    public static PlatformCallback Instance { get; private set; }

    void Awake()
    {
        // 单例模式实现
        if (Instance != null && Instance != this)
        {
            NativeLogger.I("fastsdk_unity_result", "[        ] Destroying duplicate instance");
            Destroy(gameObject);
            return;
        }

        Instance = this;

        // 确保接收器在场景切换中不被销毁
        DontDestroyOnLoad(gameObject);

        // 确保游戏对象名称与 Android 调用匹配
        gameObject.name = "PlatformCallback";

        NativeLogger.I("fastsdk_unity_result", "[PlatformCallback] Initialized with GameObject name: " + gameObject.name);
    }


    public void onInitSuccess(string jsonStr)
    {
        NativeLogger.I("fastsdk_unity_result", "[AndroidBrigsCall] onInitSuccess called with result: " + jsonStr);
        InitResult result = JsonConvert.DeserializeObject<InitResult>(jsonStr);
        if (result != null)
        {
            NativeLogger.I("fastsdk_unity_result", "反序列化成功！");
            NativeLogger.I("fastsdk_unity_result", "Channel: " + result.channel);
            NativeLogger.I("fastsdk_unity_result", "Game ID: " + result.gameId);       
            NativeLogger.I("fastsdk_unity_result", "Channel ID: " + result.channelId); 
        }
    }

    public void onInitFailed(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onInitFailed called with reason: " + reason);
        
    }

    //自定义退出界面
    public void onCustomExit()
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onCustomExit called");
    }

    //预留
    public void onUpdate(string data)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onUpdate called with data: " + data);
    }

    //登录成功
    public void onLoginSuccess(string jsonStr)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onLoginSuccess called with result: " + jsonStr);
        

        //判断 null 或空字符串判断空白字符串（包括空格、制表符等）
        if (string.IsNullOrEmpty(jsonStr) || string.IsNullOrWhiteSpace(jsonStr))
        {
            NativeLogger.I("fastsdk_unity_result", "[Unity] Android returned empty or invalid string");
            return;
        }
        LoginResult loginResult = JsonConvert.DeserializeObject<LoginResult>(jsonStr);

        if (loginResult.uid != 0) {
            // 示例：如果接收到特定消息，切换到另一个场景
            NativeLogger.I("fastsdk_unity_result", $"[Unity] Login successful, uid:{loginResult.uid} channel:{loginResult.channel} channelUid:{loginResult.channelUid} accessToken:{loginResult.accessToken}"); 
        }

    }

    public void onRefreshUser(string jsonStr)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onRefreshUser called with result: " + jsonStr);

        //判断 null 或空字符串判断空白字符串（包括空格、制表符等）
        if (string.IsNullOrEmpty(jsonStr) || string.IsNullOrWhiteSpace(jsonStr))
        {
            NativeLogger.I("fastsdk_unity_result", "[Unity] Android returned empty or invalid string");
            return;
        }
        LoginResult loginResult = JsonConvert.DeserializeObject<LoginResult>(jsonStr);

        if (loginResult.uid != 0)
        {
            // 示例：如果接收到特定消息，切换到另一个场景
            NativeLogger.I("fastsdk_unity_result", $"[Unity] onRefreshUser Login successful, uid:{loginResult.uid} channel:{loginResult.channel} channelUid:{loginResult.channelUid} accessToken:{loginResult.accessToken}");
        }
    }

    public void onLoginFailed(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onLoginFailed called with reason: " + reason);
        
    }

    public void onLogout(string message)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onLogout called with message: " + message);
       
    }

    public void onPayGoodsList(string jsonStr)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onPayGoodsList called with message: " + jsonStr);
        GoodsListWrapper wrapper = JsonConvert.DeserializeObject<GoodsListWrapper>(jsonStr);

        if (wrapper != null && wrapper.array != null)
        {
            NativeLogger.I("fastsdk_unity_result", $"[Unity] onPayGoodsList: {wrapper}");

        }
    }

    public void onPaySuccess(string jsonStr)
    {
        NativeLogger.I("fastsdk_unity_result", $"[Unity] onPaySuccess called {jsonStr}");
        
    }

    public void onPayFailed(string reason)
    {
        NativeLogger.I("fastsdk_unity_result", "[Unity] onPayFailed called with reason: " + reason);
        
    }


    //分享，无特殊处理可不实现
    public void onShareSuccess(string jsonStr)
    {
        NativeLogger.I("fastsdk_unity_result", $"[Unity] onShareSuccess called {jsonStr}");
    }

    public void onShareFailed(string jsonStr)
    {
        NativeLogger.I("fastsdk_unity_result", $"[Unity] onShareFailed called {jsonStr}");
    }

}
