using System.Collections;
using System.Collections.Generic;
using Newtonsoft.Json;
using UnityEngine;

public class GameManager : MonoBehaviour
{
    public void OnLoginBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked login");
        //SdkPluginManager.CallSdkLogin();
        HoolaiSdkManager.Login();
    }

    public void OnLogoutBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked logout");
        HoolaiSdkManager.Logout();
    }

    public void OnEnterServerBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked EnterServer");
        PlayerInfo playerInfo = new PlayerInfo();
        playerInfo.RoleId = "1234567";
        playerInfo.RoleName = "大鹏一日同风起";
        playerInfo.RoleLevel = "999";
        playerInfo.ZoneId = "1";
        playerInfo.ZoneName = "傲视九重天";
        playerInfo.ServerId = "1";
        playerInfo.ServerName = "牛逼格拉斯";
        playerInfo.Balance = "9999";
        playerInfo.Vip = "99";
        playerInfo.PartyName = "少林寺";
        playerInfo.AppVersion = "1.0.1";
        playerInfo.AppResVersion = "100";
        playerInfo.ExtendAction = "无敌";
        playerInfo.RoleCreateTime = "";
        playerInfo.Phylum = "100";
        playerInfo.ClassField = "滴滴滴答";

        playerInfo.AddExtra("intKey", 55);
        playerInfo.AddExtra("longLongKey", 66786658787676);
        playerInfo.AddExtra("stringKey", "Hello111");


        HoolaiSdkManager.SendEvent(EventType.EnterServer, playerInfo);
        HoolaiSdkManager.SendEvent(EventType.CreateRole, playerInfo);
        HoolaiSdkManager.SendEvent(EventType.LevelUp, playerInfo);
        HoolaiSdkManager.SendEvent(EventType.CustomerAction, playerInfo);
    }


    public void OnPayBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked Pay");

        // 1. 创建并填充对象
        PayParams payParams = new PayParams
        {
            Amount = 100,
            ItemId = "sword_101",
            ItemName = "钻石",
            CallbackInfo = "123456_8888_987654321",
            NotifyUrl = "",
            Count = 1,
            Currency = "USD"
        };
        payParams.AddOptionalParameter("test", "daily_bonus");
        payParams.AddOptionalParameter("player_id", "p-98765");

        NativeLogger.I("fastsdk_btn_unity", $"clicked Exit jsonString: {payParams}");
        HoolaiSdkManager.StartPay(payParams);
    }

    public void OnExitBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked Exit");
        HoolaiSdkManager.ExitGame();
    }

    public void OnGetProductInfoBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked QueryGoodsInfo");
        HoolaiSdkManager.QueryGoodsInfo();
    }

    // 新增方法：使用商品列表中的第一条数据进行支付
    public void OnPayWithFirstGoodsBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked Pay With First Goods");

        List<GoodsInfo> goodsList = PlatformCallback.GetCachedGoodsList();

        if (goodsList == null || goodsList.Count == 0)
        {
            NativeLogger.I("fastsdk_btn_unity", "No goods list available. Please query goods info first.");
            return;
        }

        // 使用第一条商品数据进行支付
        GoodsInfo firstGoods = GetGoodsInfoByIndex(goodsList, 0);
        if (firstGoods != null)
        {
            // 将GoodsInfo转换为PayParams
            PayParams payParams = ConvertGoodsInfoToPayParams(firstGoods, 1);

            if (payParams != null)
            {
                NativeLogger.I("fastsdk_btn_unity", $"Paying with goods: {firstGoods.itemName}");
                HoolaiSdkManager.StartPay(payParams);
            }
            else
            {
                NativeLogger.I("fastsdk_btn_unity", "Failed to convert goods info to pay params");
            }
        }
        else
        {
            NativeLogger.I("fastsdk_btn_unity", "No goods available at index 0");
        }
    }


    // 添加方法用于根据索引获取单个商品信息
    public static GoodsInfo GetGoodsInfoByIndex(List<GoodsInfo> goodsList, int index)
    {
        if (goodsList != null &&
            index >= 0 &&
            index < goodsList.Count)
        {
            return goodsList[index];
        }
        return null;
    }


    // 新增方法：使用指定索引的商品数据进行支付
    public void OnPayWithSpecificGoodsBtnClicked(int goodsIndex)
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked Pay With Random Goods");

        // 获取缓存的商品列表
        List<GoodsInfo> goodsList = PlatformCallback.GetCachedGoodsList();

        if (goodsList == null || goodsList.Count == 0)
        {
            NativeLogger.I("fastsdk_btn_unity", "No goods list available. Please query goods info first.");
            return;
        }

        System.Random random = new System.Random();
        int randomIndex = random.Next(0, goodsList.Count);
        GoodsInfo randomGoods = GetGoodsInfoByIndex(goodsList, randomIndex);

        if (randomGoods != null)
        {
            // 将GoodsInfo转换为PayParams
            PayParams payParams = ConvertGoodsInfoToPayParams(randomGoods, 1);

            if (payParams != null)
            {
                NativeLogger.I("fastsdk_btn_unity", $"Paying with random goods: {randomGoods.itemName} at index {randomIndex}");
                HoolaiSdkManager.StartPay(payParams);
            }
            else
            {
                NativeLogger.I("fastsdk_btn_unity", "Failed to convert goods info to pay params");
            }
        }
        else
        {
            NativeLogger.I("fastsdk_btn_unity", "No goods available at random index");
        }
    }


    // 添加方法用于将GoodsInfo转换为PayParams
    public PayParams ConvertGoodsInfoToPayParams(GoodsInfo goodsInfo, int count = 1)
    {
        if (goodsInfo == null) return null;
        System.Random random = new System.Random();
        int randomIndex = random.Next(0, 100);
        PayParams payParams = new PayParams
        {
            // 根据GoodsInfo的数据填充PayParams
            Amount = int.TryParse(goodsInfo.itemPrice, out int price) ? price : 1,
            ItemId = goodsInfo.itemId ?? "goods_info_6",
            ItemName = goodsInfo.itemName ?? "宝石",
            Count = count,
            CallbackInfo = "Game_itemId_"+ randomIndex, // 游戏透传参数，必传
            NotifyUrl = "",    // 支付回调地址，默认使用客户端传递的
            Currency = goodsInfo.currency ?? "USD"
        };

        return payParams;
    }

    public void OnCDKBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked CDKey");
        HoolaiSdkManager.AccessParticipate(AccessActivityType.CD_KEY, "123456789");
    }


    public void OnShareBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked shareData");
        HoolaiSdkManager.ShareData(1, 1, "test");
    }

    public void OnOpenServiceBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked openService");
        HoolaiSdkManager.OpenService();
    }

    public void OnOpenAccountBtnClicked()
    {
        NativeLogger.I("fastsdk_btn_unity", "clicked openAccount");
        HoolaiSdkManager.OpenAccountCenter();
    }
}
