using System;
using UnityEngine;
using UnityEngine.Scripting;
[Preserve]
public class HarmonySdkInterface
{
    private static OpenHarmonyJSObject _openHarmonyJSObject;
    private static OpenHarmonyJSObject ServiceInstance
    {
        get
        {
            if (_openHarmonyJSObject == null)
            {
                NativeLogger.I("fastsdk_btn_unity", $"_openHarmonyJSObject 初始化");
                try
                {
                    _openHarmonyJSObject = new OpenHarmonyJSObject("UnityApiBridge") ;
                }
                catch (System.Exception ex)
                {
                    NativeLogger.I("fastsdk_btn_unity", $"UnityApiBridge 异常: {ex.Message}");
                }
            }
            return _openHarmonyJSObject;
        }
    }

    private static void SDKStaticCall(string method, params object[] param)
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call(method, param);
                NativeLogger.I("fastsdk_btn_unity", $"call UnityApiBridge {method}");
            });
        }
        catch (Exception e)
        {
            NativeLogger.I("fastsdk_btn_unity", $" call UnityApiBridge.{method} 异常: {e.Message}");
        }
    }

    public static void CallSdkInit()
    {
        SDKStaticCall("initSDK");
    }

    public static void CallSdkLogin()
    {
        SDKStaticCall("login");
    }

    public static void CallSdkLogout()
    {
        SDKStaticCall("logout");
    }

    public static void CallSdkSwitchAccount()
    {
        SDKStaticCall("switchAccount");
    }

    public static void CallSdkStartPay(string jsonStr)
    {
        SDKStaticCall("startPay",jsonStr);
    }

    public static void CallSdkExit()
    {
        SDKStaticCall("exit");
    }

    public static void CallSdkSendEvent(EventType type, string jsonStr)
    {
        SDKStaticCall("sendEvent", (int)type, jsonStr);
    }

    public static void CallSdkCDKey(AccessActivityType accessType, string key)
    {
        SDKStaticCall("accessParticipate", (int)accessType, key);
    }


    public static void CallSdkOpenService()
    {
        SDKStaticCall("openService");
    }

    public static void CallSdkOpenAccount()
    {
        SDKStaticCall("openAccount");
    }

    public static void CallSdkShareData(int type, int childType, string jsonStr)
    {
        SDKStaticCall("shareData", type, childType, jsonStr);
    }
}