using System.Collections.Generic;

public interface IPlatformCallbackListener
{
    void OnInitSuccess(InitResult result);
    void OnInitFailed(string reason);
    void OnUpdate(string data);
    void OnLoginSuccess(LoginResult result);
    void OnLoginFailed(string reason);
    void OnRefreshUser(LoginResult result);
    void OnLogout(string message);
    void OnPayGoodsList(List<GoodsInfo> goodsList);
    void OnPaySuccess(string message);
    void OnPayFailed(string reason);
    void OnShareSuccess(string message);
    void OnShareFailed(string reason);
    void OnCustomExit();
}