using UnityEngine;

public class AndroidSdkInterface : MonoBehaviour
{
    private static AndroidJavaClass _serviceClass;
    private static AndroidJavaObject _serviceInstance;

    // 缓存 AndroidJavaClass 和实例对象
    private static AndroidJavaObject ServiceInstance
    {
        get
        {
            if (_serviceInstance == null)
            {
                try
                {
                    _serviceClass = new AndroidJavaClass("com.unity.game.plugin.SdkManager");
                    _serviceInstance = _serviceClass.CallStatic<AndroidJavaObject>("getInstance");
                }
                catch (System.Exception ex)
                {
                    NativeLogger.I("fastsdk_btn_unity", $"JavaManager 初始化失败: {ex.Message}");
                }
            }
            return _serviceInstance;
        }
    }

    /// <summary>
    /// 调用 SdkManager 的 login 方法，确保在主线程执行，异常安全，资源释放
    /// </summary>
    public static void CallSdkLogin()
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("login");
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager login");
            });
           
        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.login 异常: {ex.Message}");
        }
    }


    public static void CallSdkLogout()
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("logout");
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager logout");
            });
        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.logout 异常: {ex.Message}");
        }
    }


    public static void CallSdkStartPay(string jsonStr)
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("startPay", jsonStr);
            });
        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.pay 异常: {ex.Message}");
        }
    }


    public static void CallSdkExit()
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("exit");
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager exit");
            });
        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.exit 异常: {ex.Message}");
        }
    }


    public static void CallSdkSendEvent(EventType type,string jsonStr)
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                int eventTypeCode = (int)type;
                ServiceInstance?.Call("sendEvent", eventTypeCode, jsonStr);
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager sendEvent");
            });
        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.enterServer 异常: {ex.Message}");
        }
    }

    public static void CallSdkQueryGoodsInfo()
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("queryGoodsInfo");
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager queryGoodsInfo");
            });

        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.CallSdkQueryGoodsInfo 异常: {ex.Message}");
        }
    }

    public static void CallSdkCDKey(AccessActivityType accessType, string key)
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                int keyType = (int)accessType;
                ServiceInstance?.Call("accessParticipate", keyType, key);
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager accessParticipate");
            });

        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.accessParticipate 异常: {ex.Message}");
        }
    }

    public static void CallSdkOpenService()
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("openService");
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager openService");
            });

        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.openService 异常: {ex.Message}");
        }
    }

    public static void CallSdkOpenAccount()
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("openAccount");
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager openAccount");
            });

        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.openAccount 异常: {ex.Message}");
        }
    }

    public static void CallSdkShareData(int type, string jsonStr)
    {
        try
        {
            UnityMainThreadDispatcher.Instance.Enqueue(() => {
                ServiceInstance?.Call("shareData", type, jsonStr);
                NativeLogger.I("fastsdk_btn_unity", "call SdkManager shareData");
            });

        }
        catch (System.Exception ex)
        {
            NativeLogger.I("fastsdk_btn_unity", $"调用 SdkManager.shareData 异常: {ex.Message}");
        }
    }
}